"use strict";(globalThis.webpackChunk_plex_client_qt=globalThis.webpackChunk_plex_client_qt||[]).push([["packages_visualizer_shaders_rays_glsl"],{34057:n=>{n.exports="precision mediump float;\n\nuniform float uTime;\nuniform vec2 uResolution;\nvarying vec2 vTextureCoord;\nvarying vec4 vColor;\nuniform sampler2D uSampler;\nuniform sampler2D uSampler2;\n\n#define PI 3.1415\n\nconst float SLICES = 24.0;\nconst float RADIUS = 0.35;\nconst float ANGLE = PI / SLICES;\nconst float BRIGHTNESS = 0.2;\nconst float SPEED = 0.6;\n\nfloat getFreq(float slice) {\n  return texture2D(uSampler, vec2(slice/SLICES, 0.0)).x + 0.06;\n}\n\nfloat luma(vec3 color) {\n  return dot(color, vec3(0.299, 0.587, 0.114));\n}\n\n//convert HSV to RGB\nvec3 hsv2rgb(vec3 c){\n  vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);\n  vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);\n  return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);\n}\n\nvec3 drawLogo(vec2 fragment, float radius) {\n  float dist = length(fragment);\n  vec3 col = vec3(0.0);\n  vec2 uv = fragment * 1.40 + 0.5;\n\n  if (dist < radius) {\n    vec2 uv = fragment * 1.4 + 0.5;\n    col = texture2D(uSampler2, uv).rgb;\n  }\n\n  return col;\n}\n\nvec3 drawRays(vec2 uv, float ray, float dist, float radius, float brightness) {\n  float start = ray * ANGLE;\n  float end = (ray + 1.0) * ANGLE;\n  float angle = abs(atan(uv.x, uv.y));\n  float freq = getFreq(ray) * 0.5;\n  float length = radius + freq * 3.0;\n  vec3 col = vec3(0.0);\n\n  if (angle > start && angle < end) {\n    col = hsv2rgb( vec3( ( angle + uTime * 0.25 ) / (PI * 2.0), 0.7, 0.65 ) );\n    col *= brightness * freq;\n    col *= smoothstep(radius * 0.9, radius, dist);\n  }\n\n  return col;\n}\n\nvoid main( void )\n{\n  // Normalized pixel coordinates (from 0 to 1)\n  vec2 uv = vec2(vTextureCoord.x, 1.0 - vTextureCoord.y);\n  uv = (uv - 0.5) * 2.0;\n  uv.x *= uResolution.x / uResolution.y;\n\n  float dist = length(uv);\n  float ring = 1.0 / (abs(dist - RADIUS));\n  float b = dist < RADIUS ? BRIGHTNESS * 0.07 : BRIGHTNESS;\n  vec3 col = vec3(0.0134, 0.052, 0.1);\n\n  col += drawLogo(uv, RADIUS);\n\n  for(float i = 0.0; i < SLICES; i++) {\n    col += drawRays(uv, i, dist, RADIUS, ring * b);\n  }\n\n  col += max(luma(col) - 1.0, 0.0);\n\n  // Output to screen\n  gl_FragColor = vec4(col, 1.0);\n}\n"}}]);