#!/bin/sh

. /etc/service.subr

SCRIPTPATH="$(dirname "$(realpath "$0")")"

name="plex"
version="1.30.3.6509"
description="Plex organizes all of your personal media so you can easily access and enjoy it."
framework_version="2.1"
depends=""
webui=":32400/web/index.html"

pidfile="/tmp/DroboApps/${name}/pid.txt"
daemon="${SCRIPTPATH}/Application/Plex Media Server"

is_running() {
  /sbin/start-stop-daemon -K -t -p "${pidfile}" -x "${daemon}" -q 2> /dev/null
}

start() {
  export PLEX_MEDIA_SERVER_INFO_VENDOR=Drobo
  export PLEX_MEDIA_SERVER_INFO_DEVICE="Drobo $(cat "/sys/bus/scsi/devices/0:0:0:0/model" | xargs)"
  export PLEX_MEDIA_SERVER_INFO_MODEL="$(uname -m)"
  export PLEX_MEDIA_SERVER_INFO_PLATFORM_VERSION="$(wget -O - -q -t 1 --timeout=1 http://127.0.0.1:5000 | awk -F '[<>]' '/mVersion/{print $3;exit}')"
  export PLEX_MEDIA_SERVER_HOME="${SCRIPTPATH}/Application"
  export PLEX_MEDIA_SERVER_MAX_PLUGIN_PROCS=6
  export PLEX_MEDIA_SERVER_PIDFILE="${pidfile}"
  export PLEX_MEDIA_SERVER_APPLICATION_SUPPORT_DIR="${SCRIPTPATH}/Library"
  export PLEX_MEDIA_SERVER_DEFAULT_PREFERENCES='TranscoderCanOnlyRemuxVideo=true'
  export PLEX_BROWSER_ROOT="/mnt/DroboFS/Shares"
  export TMPDIR="${PLEX_MEDIA_SERVER_APPLICATION_SUPPORT_DIR}/tmp"
  export LC_ALL="C"
  export LANG="C"
  ulimit -s 3000
  mkdir -p "${TMPDIR}"
  (exec 3>&- 4>&- /sbin/start-stop-daemon -S -x "${daemon}" -b -q)
}

stop() {
  /sbin/start-stop-daemon -K -s INT -p "${pidfile}" -x "${daemon}" -q
}

force_stop() {
  /sbin/start-stop-daemon -K -s KILL -p "${pidfile}" -x "${daemon}" -q
}

main "${@}"
